package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PublishedResource;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.PublishedResourceRequest;

public class PublishedResourceCollectionRequest extends CollectionPageEntityRequest<PublishedResource, PublishedResourceRequest>{

    protected ContextPath contextPath;

    public PublishedResourceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PublishedResource.class, cp -> new PublishedResourceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(contextPath.addSegment("agentGroups"), Optional.empty());
    }

}
