package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrivilegedRoleAssignment;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequest;

public class PrivilegedRoleAssignmentCollectionRequest extends CollectionPageEntityRequest<PrivilegedRoleAssignment, PrivilegedRoleAssignmentRequest>{

    protected ContextPath contextPath;

    public PrivilegedRoleAssignmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrivilegedRoleAssignment.class, cp -> new PrivilegedRoleAssignmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "my")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrivilegedRoleAssignment> my() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.my"), PrivilegedRoleAssignment.class, _parameters);
    }

}
