package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrintTaskDefinition;
import odata.msgraph.client.beta.entity.request.PrintTaskDefinitionRequest;
import odata.msgraph.client.beta.entity.request.PrintTaskRequest;

public class PrintTaskDefinitionCollectionRequest extends CollectionPageEntityRequest<PrintTaskDefinition, PrintTaskDefinitionRequest>{

    protected ContextPath contextPath;

    public PrintTaskDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrintTaskDefinition.class, cp -> new PrintTaskDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

}
