package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerPlan;
import odata.msgraph.client.beta.entity.request.PlannerBucketRequest;
import odata.msgraph.client.beta.entity.request.PlannerPlanRequest;
import odata.msgraph.client.beta.entity.request.PlannerTaskRequest;

public class PlannerPlanCollectionRequest extends CollectionPageEntityRequest<PlannerPlan, PlannerPlanRequest>{

    protected ContextPath contextPath;

    public PlannerPlanCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PlannerPlan.class, cp -> new PlannerPlanRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PlannerBucketRequest buckets(String id) {
        return new PlannerBucketRequest(contextPath.addSegment("buckets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerBucketCollectionRequest buckets() {
        return new PlannerBucketCollectionRequest(contextPath.addSegment("buckets"), Optional.empty());
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

}
