package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerBucket;
import odata.msgraph.client.beta.entity.request.PlannerBucketRequest;
import odata.msgraph.client.beta.entity.request.PlannerTaskRequest;

public class PlannerBucketCollectionRequest extends CollectionPageEntityRequest<PlannerBucket, PlannerBucketRequest>{

    protected ContextPath contextPath;

    public PlannerBucketCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PlannerBucket.class, cp -> new PlannerBucketRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

}
