package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PermissionGrantPolicy;
import odata.msgraph.client.beta.entity.request.PermissionGrantConditionSetRequest;
import odata.msgraph.client.beta.entity.request.PermissionGrantPolicyRequest;

public class PermissionGrantPolicyCollectionRequest extends CollectionPageEntityRequest<PermissionGrantPolicy, PermissionGrantPolicyRequest>{

    protected ContextPath contextPath;

    public PermissionGrantPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PermissionGrantPolicy.class, cp -> new PermissionGrantPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PermissionGrantConditionSetRequest excludes(String id) {
        return new PermissionGrantConditionSetRequest(contextPath.addSegment("excludes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionGrantConditionSetCollectionRequest excludes() {
        return new PermissionGrantConditionSetCollectionRequest(contextPath.addSegment("excludes"), Optional.empty());
    }

    public PermissionGrantConditionSetRequest includes(String id) {
        return new PermissionGrantConditionSetRequest(contextPath.addSegment("includes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionGrantConditionSetCollectionRequest includes() {
        return new PermissionGrantConditionSetCollectionRequest(contextPath.addSegment("includes"), Optional.empty());
    }

}
