package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OutlookTaskFolder;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskFolderRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;

public class OutlookTaskFolderCollectionRequest extends CollectionPageEntityRequest<OutlookTaskFolder, OutlookTaskFolderRequest>{

    protected ContextPath contextPath;

    public OutlookTaskFolderCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OutlookTaskFolder.class, cp -> new OutlookTaskFolderRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

    public OutlookTaskRequest tasks(String id) {
        return new OutlookTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskCollectionRequest tasks() {
        return new OutlookTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

}
