package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnPremisesAgent;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentRequest;

public class OnPremisesAgentCollectionRequest extends CollectionPageEntityRequest<OnPremisesAgent, OnPremisesAgentRequest>{

    protected ContextPath contextPath;

    public OnPremisesAgentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OnPremisesAgent.class, cp -> new OnPremisesAgentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(contextPath.addSegment("agentGroups"), Optional.empty());
    }

}
