package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OfficeClientConfiguration;
import odata.msgraph.client.beta.entity.request.OfficeClientConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.OfficeClientConfigurationRequest;

public class OfficeClientConfigurationCollectionRequest extends CollectionPageEntityRequest<OfficeClientConfiguration, OfficeClientConfigurationRequest>{

    protected ContextPath contextPath;

    public OfficeClientConfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OfficeClientConfiguration.class, cp -> new OfficeClientConfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OfficeClientConfigurationAssignmentRequest assignments(String id) {
        return new OfficeClientConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OfficeClientConfigurationAssignmentCollectionRequest assignments() {
        return new OfficeClientConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "updatePriorities")
    @JsonIgnore
    public ActionRequestNoReturn updatePriorities(List<String> officeConfigurationPolicyIds, List<Integer> officeConfigurationPriorities) {
        Preconditions.checkNotNull(officeConfigurationPriorities, "officeConfigurationPriorities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("officeConfigurationPolicyIds", "Collection(Edm.String)", Checks.checkIsAscii(officeConfigurationPolicyIds))
            .put("officeConfigurationPriorities", "Collection(Edm.Int32)", officeConfigurationPriorities)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updatePriorities"), _parameters);
    }

}
