package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.NotificationMessageTemplate;
import odata.msgraph.client.beta.entity.request.LocalizedNotificationMessageRequest;
import odata.msgraph.client.beta.entity.request.NotificationMessageTemplateRequest;

public class NotificationMessageTemplateCollectionRequest extends CollectionPageEntityRequest<NotificationMessageTemplate, NotificationMessageTemplateRequest>{

    protected ContextPath contextPath;

    public NotificationMessageTemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, NotificationMessageTemplate.class, cp -> new NotificationMessageTemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public LocalizedNotificationMessageRequest localizedNotificationMessages(String id) {
        return new LocalizedNotificationMessageRequest(contextPath.addSegment("localizedNotificationMessages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LocalizedNotificationMessageCollectionRequest localizedNotificationMessages() {
        return new LocalizedNotificationMessageCollectionRequest(contextPath.addSegment("localizedNotificationMessages"), Optional.empty());
    }

}
