package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobileAppTroubleshootingEvent;
import odata.msgraph.client.beta.entity.request.AppLogCollectionRequestRequest;
import odata.msgraph.client.beta.entity.request.MobileAppTroubleshootingEventRequest;

public class MobileAppTroubleshootingEventCollectionRequest extends CollectionPageEntityRequest<MobileAppTroubleshootingEvent, MobileAppTroubleshootingEventRequest>{

    protected ContextPath contextPath;

    public MobileAppTroubleshootingEventCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MobileAppTroubleshootingEvent.class, cp -> new MobileAppTroubleshootingEventRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AppLogCollectionRequestRequest appLogCollectionRequests(String id) {
        return new AppLogCollectionRequestRequest(contextPath.addSegment("appLogCollectionRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppLogCollectionRequestCollectionRequest appLogCollectionRequests() {
        return new AppLogCollectionRequestCollectionRequest(contextPath.addSegment("appLogCollectionRequests"), Optional.empty());
    }

}
