package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobileAppContent;
import odata.msgraph.client.beta.entity.request.MobileAppContentFileRequest;
import odata.msgraph.client.beta.entity.request.MobileAppContentRequest;
import odata.msgraph.client.beta.entity.request.MobileContainedAppRequest;

public class MobileAppContentCollectionRequest extends CollectionPageEntityRequest<MobileAppContent, MobileAppContentRequest>{

    protected ContextPath contextPath;

    public MobileAppContentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MobileAppContent.class, cp -> new MobileAppContentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MobileContainedAppRequest containedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("containedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileContainedAppCollectionRequest containedApps() {
        return new MobileContainedAppCollectionRequest(contextPath.addSegment("containedApps"), Optional.empty());
    }

    public MobileAppContentFileRequest files(String id) {
        return new MobileAppContentFileRequest(contextPath.addSegment("files").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppContentFileCollectionRequest files() {
        return new MobileAppContentFileCollectionRequest(contextPath.addSegment("files"), Optional.empty());
    }

}
