package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.MobileApp;
import odata.msgraph.client.beta.entity.request.MobileAppAssignmentRequest;
import odata.msgraph.client.beta.entity.request.MobileAppCategoryRequest;
import odata.msgraph.client.beta.entity.request.MobileAppInstallStatusRequest;
import odata.msgraph.client.beta.entity.request.MobileAppRelationshipRequest;
import odata.msgraph.client.beta.entity.request.MobileAppRequest;
import odata.msgraph.client.beta.entity.request.UserAppInstallStatusRequest;

public class MobileAppCollectionRequest extends CollectionPageEntityRequest<MobileApp, MobileAppRequest>{

    protected ContextPath contextPath;

    public MobileAppCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MobileApp.class, cp -> new MobileAppRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MobileAppAssignmentRequest assignments(String id) {
        return new MobileAppAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppAssignmentCollectionRequest assignments() {
        return new MobileAppAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public MobileAppCategoryRequest categories(String id) {
        return new MobileAppCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppCategoryCollectionRequest categories() {
        return new MobileAppCategoryCollectionRequest(contextPath.addSegment("categories"), Optional.empty());
    }

    public MobileAppInstallStatusRequest deviceStatuses(String id) {
        return new MobileAppInstallStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppInstallStatusCollectionRequest deviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public MobileAppRelationshipRequest relationships(String id) {
        return new MobileAppRelationshipRequest(contextPath.addSegment("relationships").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppRelationshipCollectionRequest relationships() {
        return new MobileAppRelationshipCollectionRequest(contextPath.addSegment("relationships"), Optional.empty());
    }

    public UserAppInstallStatusRequest userStatuses(String id) {
        return new UserAppInstallStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserAppInstallStatusCollectionRequest userStatuses() {
        return new UserAppInstallStatusCollectionRequest(contextPath.addSegment("userStatuses"), Optional.empty());
    }

    @Action(name = "validateXml")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> validateXml(byte[] officeConfigurationXml) {
        Preconditions.checkNotNull(officeConfigurationXml, "officeConfigurationXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("officeConfigurationXml", "Edm.Binary", officeConfigurationXml)
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateXml"), String.class, _parameters);
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters);
    }

    @Function(name = "getMobileAppCount")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Long> getMobileAppCount(String status) {
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("status", "Edm.String", Checks.checkIsAscii(status))
            .build();
        return new FunctionRequestReturningNonCollection<Long>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMobileAppCount"), Long.class, _parameters);
    }

    @Function(name = "getTopMobileApps")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MobileApp> getTopMobileApps(String status, Long count) {
        Preconditions.checkNotNull(status, "status cannot be null");
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("status", "Edm.String", Checks.checkIsAscii(status))
            .put("count", "Edm.Int64", count)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTopMobileApps"), MobileApp.class, _parameters);
    }

}
