package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MessageTrace;
import odata.msgraph.client.beta.entity.request.MessageRecipientRequest;
import odata.msgraph.client.beta.entity.request.MessageTraceRequest;

public class MessageTraceCollectionRequest extends CollectionPageEntityRequest<MessageTrace, MessageTraceRequest>{

    protected ContextPath contextPath;

    public MessageTraceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MessageTrace.class, cp -> new MessageTraceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MessageRecipientRequest recipients(String id) {
        return new MessageRecipientRequest(contextPath.addSegment("recipients").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageRecipientCollectionRequest recipients() {
        return new MessageRecipientCollectionRequest(contextPath.addSegment("recipients"), Optional.empty());
    }

}
