package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagementConditionStatement;
import odata.msgraph.client.beta.entity.request.ManagementConditionRequest;
import odata.msgraph.client.beta.entity.request.ManagementConditionStatementRequest;
import odata.msgraph.client.beta.enums.DevicePlatformType;

public class ManagementConditionStatementCollectionRequest extends CollectionPageEntityRequest<ManagementConditionStatement, ManagementConditionStatementRequest>{

    protected ContextPath contextPath;

    public ManagementConditionStatementCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagementConditionStatement.class, cp -> new ManagementConditionStatementRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagementConditionRequest managementConditions(String id) {
        return new ManagementConditionRequest(contextPath.addSegment("managementConditions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementConditionCollectionRequest managementConditions() {
        return new ManagementConditionCollectionRequest(contextPath.addSegment("managementConditions"), Optional.empty());
    }

    @Function(name = "getManagementConditionStatementsForPlatform")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagementConditionStatement> getManagementConditionStatementsForPlatform(DevicePlatformType platform) {
        Preconditions.checkNotNull(platform, "platform cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("platform", "microsoft.graph.devicePlatformType", platform)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagementConditionStatementsForPlatform"), ManagementConditionStatement.class, _parameters);
    }

}
