package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedEBook;
import odata.msgraph.client.beta.entity.request.DeviceInstallStateRequest;
import odata.msgraph.client.beta.entity.request.ManagedEBookAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ManagedEBookCategoryRequest;
import odata.msgraph.client.beta.entity.request.ManagedEBookRequest;
import odata.msgraph.client.beta.entity.request.UserInstallStateSummaryRequest;

public class ManagedEBookCollectionRequest extends CollectionPageEntityRequest<ManagedEBook, ManagedEBookRequest>{

    protected ContextPath contextPath;

    public ManagedEBookCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagedEBook.class, cp -> new ManagedEBookRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagedEBookAssignmentRequest assignments(String id) {
        return new ManagedEBookAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedEBookAssignmentCollectionRequest assignments() {
        return new ManagedEBookAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public ManagedEBookCategoryRequest categories(String id) {
        return new ManagedEBookCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedEBookCategoryCollectionRequest categories() {
        return new ManagedEBookCategoryCollectionRequest(contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(contextPath.addSegment("deviceStates"), Optional.empty());
    }

    public UserInstallStateSummaryRequest userStateSummary(String id) {
        return new UserInstallStateSummaryRequest(contextPath.addSegment("userStateSummary").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserInstallStateSummaryCollectionRequest userStateSummary() {
        return new UserInstallStateSummaryCollectionRequest(contextPath.addSegment("userStateSummary"), Optional.empty());
    }

}
