package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.BulkManagedDeviceActionResult;
import odata.msgraph.client.beta.complex.CloudPcBulkRemoteActionResult;
import odata.msgraph.client.beta.entity.ManagedDevice;
import odata.msgraph.client.beta.entity.request.AssignmentFilterEvaluationStatusDetailsRequest;
import odata.msgraph.client.beta.entity.request.DetectedAppRequest;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceLogCollectionResponseRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationStateRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.entity.request.SecurityBaselineStateRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.enums.ManagedDeviceRemoteAction;
import odata.msgraph.client.beta.enums.RestoreTimeRange;

public class ManagedDeviceCollectionRequest extends CollectionPageEntityRequest<ManagedDevice, ManagedDeviceRequest>{

    protected ContextPath contextPath;

    public ManagedDeviceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagedDevice.class, cp -> new ManagedDeviceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AssignmentFilterEvaluationStatusDetailsRequest assignmentFilterEvaluationStatusDetails(String id) {
        return new AssignmentFilterEvaluationStatusDetailsRequest(contextPath.addSegment("assignmentFilterEvaluationStatusDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AssignmentFilterEvaluationStatusDetailsCollectionRequest assignmentFilterEvaluationStatusDetails() {
        return new AssignmentFilterEvaluationStatusDetailsCollectionRequest(contextPath.addSegment("assignmentFilterEvaluationStatusDetails"), Optional.empty());
    }

    public DeviceCompliancePolicyStateRequest deviceCompliancePolicyStates(String id) {
        return new DeviceCompliancePolicyStateRequest(contextPath.addSegment("deviceCompliancePolicyStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCompliancePolicyStateCollectionRequest deviceCompliancePolicyStates() {
        return new DeviceCompliancePolicyStateCollectionRequest(contextPath.addSegment("deviceCompliancePolicyStates"), Optional.empty());
    }

    public DeviceConfigurationStateRequest deviceConfigurationStates(String id) {
        return new DeviceConfigurationStateRequest(contextPath.addSegment("deviceConfigurationStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationStateCollectionRequest deviceConfigurationStates() {
        return new DeviceConfigurationStateCollectionRequest(contextPath.addSegment("deviceConfigurationStates"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationStateRequest managedDeviceMobileAppConfigurationStates(String id) {
        return new ManagedDeviceMobileAppConfigurationStateRequest(contextPath.addSegment("managedDeviceMobileAppConfigurationStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationStateCollectionRequest managedDeviceMobileAppConfigurationStates() {
        return new ManagedDeviceMobileAppConfigurationStateCollectionRequest(contextPath.addSegment("managedDeviceMobileAppConfigurationStates"), Optional.empty());
    }

    public SecurityBaselineStateRequest securityBaselineStates(String id) {
        return new SecurityBaselineStateRequest(contextPath.addSegment("securityBaselineStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecurityBaselineStateCollectionRequest securityBaselineStates() {
        return new SecurityBaselineStateCollectionRequest(contextPath.addSegment("securityBaselineStates"), Optional.empty());
    }

    public DetectedAppRequest detectedApps(String id) {
        return new DetectedAppRequest(contextPath.addSegment("detectedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DetectedAppCollectionRequest detectedApps() {
        return new DetectedAppCollectionRequest(contextPath.addSegment("detectedApps"), Optional.empty());
    }

    public DeviceLogCollectionResponseRequest logCollectionRequests(String id) {
        return new DeviceLogCollectionResponseRequest(contextPath.addSegment("logCollectionRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceLogCollectionResponseCollectionRequest logCollectionRequests() {
        return new DeviceLogCollectionResponseCollectionRequest(contextPath.addSegment("logCollectionRequests"), Optional.empty());
    }

    public UserRequest users(String id) {
        return new UserRequest(contextPath.addSegment("users").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCollectionRequest users() {
        return new UserCollectionRequest(contextPath.addSegment("users"), Optional.empty());
    }

    @Action(name = "bulkReprovisionCloudPc")
    @JsonIgnore
    public ActionRequestNoReturn bulkReprovisionCloudPc(List<String> managedDeviceIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedDeviceIds", "Collection(Edm.String)", Checks.checkIsAscii(managedDeviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bulkReprovisionCloudPc"), _parameters);
    }

    @Action(name = "bulkRestoreCloudPc")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CloudPcBulkRemoteActionResult> bulkRestoreCloudPc(List<String> managedDeviceIds, OffsetDateTime restorePointDateTime, RestoreTimeRange timeRange) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedDeviceIds", "Collection(Edm.String)", Checks.checkIsAscii(managedDeviceIds))
            .put("restorePointDateTime", "Edm.DateTimeOffset", restorePointDateTime)
            .put("timeRange", "microsoft.graph.restoreTimeRange", timeRange)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CloudPcBulkRemoteActionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bulkRestoreCloudPc"), CloudPcBulkRemoteActionResult.class, _parameters);
    }

    @Action(name = "executeAction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkManagedDeviceActionResult> executeAction(ManagedDeviceRemoteAction actionName, Boolean keepEnrollmentData, Boolean keepUserData, Boolean persistEsimDataPlan, List<String> deviceIds, String notificationTitle, String notificationBody, String deviceName, String carrierUrl, String deprovisionReason, String organizationalUnitPath) {
        Preconditions.checkNotNull(actionName, "actionName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("actionName", "microsoft.graph.managedDeviceRemoteAction", actionName)
            .put("keepEnrollmentData", "Edm.Boolean", keepEnrollmentData)
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .put("persistEsimDataPlan", "Edm.Boolean", persistEsimDataPlan)
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .put("deviceName", "Edm.String", Checks.checkIsAscii(deviceName))
            .put("carrierUrl", "Edm.String", Checks.checkIsAscii(carrierUrl))
            .put("deprovisionReason", "Edm.String", Checks.checkIsAscii(deprovisionReason))
            .put("organizationalUnitPath", "Edm.String", Checks.checkIsAscii(organizationalUnitPath))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkManagedDeviceActionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.executeAction"), BulkManagedDeviceActionResult.class, _parameters);
    }

    @Action(name = "moveDevicesToOU")
    @JsonIgnore
    public ActionRequestNoReturn moveDevicesToOU(List<UUID> deviceIds, String organizationalUnitPath) {
        Preconditions.checkNotNull(deviceIds, "deviceIds cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceIds", "Collection(Edm.Guid)", deviceIds)
            .put("organizationalUnitPath", "Edm.String", Checks.checkIsAscii(organizationalUnitPath))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.moveDevicesToOU"), _parameters);
    }

}
