package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedAppRegistration;
import odata.msgraph.client.beta.entity.request.ManagedAppOperationRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppRegistrationRequest;

public class ManagedAppRegistrationCollectionRequest extends CollectionPageEntityRequest<ManagedAppRegistration, ManagedAppRegistrationRequest>{

    protected ContextPath contextPath;

    public ManagedAppRegistrationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagedAppRegistration.class, cp -> new ManagedAppRegistrationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagedAppPolicyRequest appliedPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("appliedPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppPolicyCollectionRequest appliedPolicies() {
        return new ManagedAppPolicyCollectionRequest(contextPath.addSegment("appliedPolicies"), Optional.empty());
    }

    public ManagedAppPolicyRequest intendedPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("intendedPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppPolicyCollectionRequest intendedPolicies() {
        return new ManagedAppPolicyCollectionRequest(contextPath.addSegment("intendedPolicies"), Optional.empty());
    }

    public ManagedAppOperationRequest operations(String id) {
        return new ManagedAppOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppOperationCollectionRequest operations() {
        return new ManagedAppOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    @Function(name = "getUserIdsWithFlaggedAppRegistration")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getUserIdsWithFlaggedAppRegistration() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserIdsWithFlaggedAppRegistration"), String.class, _parameters);
    }

}
