package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSSoftwareUpdateCategorySummary;
import odata.msgraph.client.beta.entity.request.MacOSSoftwareUpdateCategorySummaryRequest;
import odata.msgraph.client.beta.entity.request.MacOSSoftwareUpdateStateSummaryRequest;

public class MacOSSoftwareUpdateCategorySummaryCollectionRequest extends CollectionPageEntityRequest<MacOSSoftwareUpdateCategorySummary, MacOSSoftwareUpdateCategorySummaryRequest>{

    protected ContextPath contextPath;

    public MacOSSoftwareUpdateCategorySummaryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MacOSSoftwareUpdateCategorySummary.class, cp -> new MacOSSoftwareUpdateCategorySummaryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MacOSSoftwareUpdateStateSummaryRequest updateStateSummaries(String id) {
        return new MacOSSoftwareUpdateStateSummaryRequest(contextPath.addSegment("updateStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOSSoftwareUpdateStateSummaryCollectionRequest updateStateSummaries() {
        return new MacOSSoftwareUpdateStateSummaryCollectionRequest(contextPath.addSegment("updateStateSummaries"), Optional.empty());
    }

}
