package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ListItem;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.entity.request.ListItemRequest;
import odata.msgraph.client.beta.entity.request.ListItemVersionRequest;

public class ListItemCollectionRequest extends CollectionPageEntityRequest<ListItem, ListItemRequest>{

    protected ContextPath contextPath;

    public ListItemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ListItem.class, cp -> new ListItemRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"), Optional.empty());
    }

    public ListItemVersionRequest versions(String id) {
        return new ListItemVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ListItemVersionCollectionRequest versions() {
        return new ListItemVersionCollectionRequest(contextPath.addSegment("versions"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ListItem> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), ListItem.class, _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ListItem> delta_Function(String token) {
        Preconditions.checkNotNull(token, "token cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("token", "Edm.String", Checks.checkIsAscii(token))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), ListItem.class, _parameters);
    }

}
