package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Journal;
import odata.msgraph.client.beta.entity.request.JournalLineRequest;
import odata.msgraph.client.beta.entity.request.JournalRequest;

public class JournalCollectionRequest extends CollectionPageEntityRequest<Journal, JournalRequest>{

    protected ContextPath contextPath;

    public JournalCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Journal.class, cp -> new JournalRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public JournalLineRequest journalLines(String id) {
        return new JournalLineRequest(contextPath.addSegment("journalLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JournalLineCollectionRequest journalLines() {
        return new JournalLineCollectionRequest(contextPath.addSegment("journalLines"), Optional.empty());
    }

}
