package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IntuneBrandingProfile;
import odata.msgraph.client.beta.entity.request.IntuneBrandingProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.IntuneBrandingProfileRequest;

public class IntuneBrandingProfileCollectionRequest extends CollectionPageEntityRequest<IntuneBrandingProfile, IntuneBrandingProfileRequest>{

    protected ContextPath contextPath;

    public IntuneBrandingProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, IntuneBrandingProfile.class, cp -> new IntuneBrandingProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public IntuneBrandingProfileAssignmentRequest assignments(String id) {
        return new IntuneBrandingProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IntuneBrandingProfileAssignmentCollectionRequest assignments() {
        return new IntuneBrandingProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
