package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ImportedAppleDeviceIdentity;
import odata.msgraph.client.beta.entity.ImportedAppleDeviceIdentityResult;
import odata.msgraph.client.beta.entity.request.ImportedAppleDeviceIdentityRequest;

public class ImportedAppleDeviceIdentityCollectionRequest extends CollectionPageEntityRequest<ImportedAppleDeviceIdentity, ImportedAppleDeviceIdentityRequest>{

    protected ContextPath contextPath;

    public ImportedAppleDeviceIdentityCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ImportedAppleDeviceIdentity.class, cp -> new ImportedAppleDeviceIdentityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "importAppleDeviceIdentityList")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ImportedAppleDeviceIdentityResult> importAppleDeviceIdentityList(List<ImportedAppleDeviceIdentity> importedAppleDeviceIdentities, Boolean overwriteImportedDeviceIdentities) {
        Preconditions.checkNotNull(overwriteImportedDeviceIdentities, "overwriteImportedDeviceIdentities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("importedAppleDeviceIdentities", "Collection(microsoft.graph.importedAppleDeviceIdentity)", importedAppleDeviceIdentities)
            .put("overwriteImportedDeviceIdentities", "Edm.Boolean", overwriteImportedDeviceIdentities)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.importAppleDeviceIdentityList"), ImportedAppleDeviceIdentityResult.class, _parameters);
    }

}
