package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignmentOrder;
import odata.msgraph.client.beta.entity.IdentityUserFlowAttributeAssignment;
import odata.msgraph.client.beta.entity.request.IdentityUserFlowAttributeAssignmentRequest;

public class IdentityUserFlowAttributeAssignmentCollectionRequest extends CollectionPageEntityRequest<IdentityUserFlowAttributeAssignment, IdentityUserFlowAttributeAssignmentRequest>{

    protected ContextPath contextPath;

    public IdentityUserFlowAttributeAssignmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, IdentityUserFlowAttributeAssignment.class, cp -> new IdentityUserFlowAttributeAssignmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "setOrder")
    @JsonIgnore
    public ActionRequestNoReturn setOrder(AssignmentOrder newAssignmentOrder) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("newAssignmentOrder", "microsoft.graph.assignmentOrder", newAssignmentOrder)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setOrder"), _parameters);
    }

    @Function(name = "getOrder")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<AssignmentOrder> getOrder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<AssignmentOrder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOrder"), AssignmentOrder.class, _parameters);
    }

}
