package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionValue;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionValueRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyPresentationValueRequest;

public class GroupPolicyDefinitionValueCollectionRequest extends CollectionPageEntityRequest<GroupPolicyDefinitionValue, GroupPolicyDefinitionValueRequest>{

    protected ContextPath contextPath;

    public GroupPolicyDefinitionValueCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyDefinitionValue.class, cp -> new GroupPolicyDefinitionValueRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicyPresentationValueRequest presentationValues(String id) {
        return new GroupPolicyPresentationValueRequest(contextPath.addSegment("presentationValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyPresentationValueCollectionRequest presentationValues() {
        return new GroupPolicyPresentationValueCollectionRequest(contextPath.addSegment("presentationValues"), Optional.empty());
    }

}
