package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyDefinition;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyPresentationRequest;

public class GroupPolicyDefinitionCollectionRequest extends CollectionPageEntityRequest<GroupPolicyDefinition, GroupPolicyDefinitionRequest>{

    protected ContextPath contextPath;

    public GroupPolicyDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyDefinition.class, cp -> new GroupPolicyDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicyPresentationRequest presentations(String id) {
        return new GroupPolicyPresentationRequest(contextPath.addSegment("presentations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyPresentationCollectionRequest presentations() {
        return new GroupPolicyPresentationCollectionRequest(contextPath.addSegment("presentations"), Optional.empty());
    }

}
