package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.FeatureRolloutPolicy;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.FeatureRolloutPolicyRequest;

public class FeatureRolloutPolicyCollectionRequest extends CollectionPageEntityRequest<FeatureRolloutPolicy, FeatureRolloutPolicyRequest>{

    protected ContextPath contextPath;

    public FeatureRolloutPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, FeatureRolloutPolicy.class, cp -> new FeatureRolloutPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DirectoryObjectRequest appliesTo(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("appliesTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest appliesTo() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("appliesTo"), Optional.empty());
    }

}
