package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ExactMatchDataStore;
import odata.msgraph.client.beta.entity.request.ExactMatchDataStoreRequest;
import odata.msgraph.client.beta.entity.request.ExactMatchSessionRequest;

public class ExactMatchDataStoreCollectionRequest extends CollectionPageEntityRequest<ExactMatchDataStore, ExactMatchDataStoreRequest>{

    protected ContextPath contextPath;

    public ExactMatchDataStoreCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ExactMatchDataStore.class, cp -> new ExactMatchDataStoreRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExactMatchSessionRequest sessions(String id) {
        return new ExactMatchSessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExactMatchSessionCollectionRequest sessions() {
        return new ExactMatchSessionCollectionRequest(contextPath.addSegment("sessions"), Optional.empty());
    }

}
