package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EmbeddedSIMActivationCodePool;
import odata.msgraph.client.beta.entity.request.EmbeddedSIMActivationCodePoolAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EmbeddedSIMActivationCodePoolRequest;
import odata.msgraph.client.beta.entity.request.EmbeddedSIMDeviceStateRequest;

public class EmbeddedSIMActivationCodePoolCollectionRequest extends CollectionPageEntityRequest<EmbeddedSIMActivationCodePool, EmbeddedSIMActivationCodePoolRequest>{

    protected ContextPath contextPath;

    public EmbeddedSIMActivationCodePoolCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EmbeddedSIMActivationCodePool.class, cp -> new EmbeddedSIMActivationCodePoolRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public EmbeddedSIMActivationCodePoolAssignmentRequest assignments(String id) {
        return new EmbeddedSIMActivationCodePoolAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmbeddedSIMActivationCodePoolAssignmentCollectionRequest assignments() {
        return new EmbeddedSIMActivationCodePoolAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public EmbeddedSIMDeviceStateRequest deviceStates(String id) {
        return new EmbeddedSIMDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmbeddedSIMDeviceStateCollectionRequest deviceStates() {
        return new EmbeddedSIMDeviceStateCollectionRequest(contextPath.addSegment("deviceStates"), Optional.empty());
    }

}
