package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationCategory;
import odata.msgraph.client.beta.entity.request.EducationCategoryRequest;

public class EducationCategoryCollectionRequest extends CollectionPageEntityRequest<EducationCategory, EducationCategoryRequest>{

    protected ContextPath contextPath;

    public EducationCategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EducationCategory.class, cp -> new EducationCategoryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationCategory> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), EducationCategory.class, _parameters);
    }

}
