package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Drive;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;

public class DriveCollectionRequest extends CollectionPageEntityRequest<Drive, DriveRequest>{

    protected ContextPath contextPath;

    public DriveCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Drive.class, cp -> new DriveRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"), Optional.empty());
    }

    public DriveItemRequest bundles(String id) {
        return new DriveItemRequest(contextPath.addSegment("bundles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest bundles() {
        return new DriveItemCollectionRequest(contextPath.addSegment("bundles"), Optional.empty());
    }

    public DriveItemRequest following(String id) {
        return new DriveItemRequest(contextPath.addSegment("following").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest following() {
        return new DriveItemCollectionRequest(contextPath.addSegment("following"), Optional.empty());
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(contextPath.addSegment("items"), Optional.empty());
    }

    public DriveItemRequest special(String id) {
        return new DriveItemRequest(contextPath.addSegment("special").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest special() {
        return new DriveItemCollectionRequest(contextPath.addSegment("special"), Optional.empty());
    }

}
