package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Domain;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DomainDnsRecordRequest;
import odata.msgraph.client.beta.entity.request.DomainRequest;
import odata.msgraph.client.beta.entity.request.InternalDomainFederationRequest;
import odata.msgraph.client.beta.entity.request.SharedEmailDomainInvitationRequest;

public class DomainCollectionRequest extends CollectionPageEntityRequest<Domain, DomainRequest>{

    protected ContextPath contextPath;

    public DomainCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Domain.class, cp -> new DomainRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DirectoryObjectRequest domainNameReferences(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("domainNameReferences").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest domainNameReferences() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("domainNameReferences"), Optional.empty());
    }

    public InternalDomainFederationRequest federationConfiguration(String id) {
        return new InternalDomainFederationRequest(contextPath.addSegment("federationConfiguration").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public InternalDomainFederationCollectionRequest federationConfiguration() {
        return new InternalDomainFederationCollectionRequest(contextPath.addSegment("federationConfiguration"), Optional.empty());
    }

    public DomainDnsRecordRequest serviceConfigurationRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("serviceConfigurationRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DomainDnsRecordCollectionRequest serviceConfigurationRecords() {
        return new DomainDnsRecordCollectionRequest(contextPath.addSegment("serviceConfigurationRecords"), Optional.empty());
    }

    public SharedEmailDomainInvitationRequest sharedEmailDomainInvitations(String id) {
        return new SharedEmailDomainInvitationRequest(contextPath.addSegment("sharedEmailDomainInvitations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SharedEmailDomainInvitationCollectionRequest sharedEmailDomainInvitations() {
        return new SharedEmailDomainInvitationCollectionRequest(contextPath.addSegment("sharedEmailDomainInvitations"), Optional.empty());
    }

    public DomainDnsRecordRequest verificationDnsRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("verificationDnsRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DomainDnsRecordCollectionRequest verificationDnsRecords() {
        return new DomainDnsRecordCollectionRequest(contextPath.addSegment("verificationDnsRecords"), Optional.empty());
    }

}
