package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Dimension;
import odata.msgraph.client.beta.entity.request.DimensionRequest;
import odata.msgraph.client.beta.entity.request.DimensionValueRequest;

public class DimensionCollectionRequest extends CollectionPageEntityRequest<Dimension, DimensionRequest>{

    protected ContextPath contextPath;

    public DimensionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Dimension.class, cp -> new DimensionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DimensionValueRequest dimensionValues(String id) {
        return new DimensionValueRequest(contextPath.addSegment("dimensionValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DimensionValueCollectionRequest dimensionValues() {
        return new DimensionValueCollectionRequest(contextPath.addSegment("dimensionValues"), Optional.empty());
    }

}
