package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceShellScript;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptGroupAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptUserStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceShellScriptRequest;

public class DeviceShellScriptCollectionRequest extends CollectionPageEntityRequest<DeviceShellScript, DeviceShellScriptRequest>{

    protected ContextPath contextPath;

    public DeviceShellScriptCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceShellScript.class, cp -> new DeviceShellScriptRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementScriptAssignmentRequest assignments(String id) {
        return new DeviceManagementScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptAssignmentCollectionRequest assignments() {
        return new DeviceManagementScriptAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

    public DeviceManagementScriptGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceManagementScriptGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceManagementScriptGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"), Optional.empty());
    }

    public DeviceManagementScriptUserStateRequest userRunStates(String id) {
        return new DeviceManagementScriptUserStateRequest(contextPath.addSegment("userRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptUserStateCollectionRequest userRunStates() {
        return new DeviceManagementScriptUserStateCollectionRequest(contextPath.addSegment("userRunStates"), Optional.empty());
    }

}
