package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementTemplateSettingCategory;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTemplateSettingCategoryRequest;

public class DeviceManagementTemplateSettingCategoryCollectionRequest extends CollectionPageEntityRequest<DeviceManagementTemplateSettingCategory, DeviceManagementTemplateSettingCategoryRequest>{

    protected ContextPath contextPath;

    public DeviceManagementTemplateSettingCategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementTemplateSettingCategory.class, cp -> new DeviceManagementTemplateSettingCategoryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingInstanceRequest recommendedSettings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("recommendedSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest recommendedSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("recommendedSettings"), Optional.empty());
    }

}
