package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementIntent;
import odata.msgraph.client.beta.entity.DeviceManagementTemplate;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTemplateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTemplateSettingCategoryRequest;

public class DeviceManagementTemplateCollectionRequest extends CollectionPageEntityRequest<DeviceManagementTemplate, DeviceManagementTemplateRequest>{

    protected ContextPath contextPath;

    public DeviceManagementTemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementTemplate.class, cp -> new DeviceManagementTemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementTemplateSettingCategoryRequest categories(String id) {
        return new DeviceManagementTemplateSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTemplateSettingCategoryCollectionRequest categories() {
        return new DeviceManagementTemplateSettingCategoryCollectionRequest(contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceManagementTemplateRequest migratableTo(String id) {
        return new DeviceManagementTemplateRequest(contextPath.addSegment("migratableTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTemplateCollectionRequest migratableTo() {
        return new DeviceManagementTemplateCollectionRequest(contextPath.addSegment("migratableTo"), Optional.empty());
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("settings"), Optional.empty());
    }

    @Action(name = "importOffice365DeviceConfigurationPolicies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementIntent> importOffice365DeviceConfigurationPolicies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.importOffice365DeviceConfigurationPolicies"), DeviceManagementIntent.class, _parameters);
    }

}
