package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementScriptUserState;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptUserStateRequest;

public class DeviceManagementScriptUserStateCollectionRequest extends CollectionPageEntityRequest<DeviceManagementScriptUserState, DeviceManagementScriptUserStateRequest>{

    protected ContextPath contextPath;

    public DeviceManagementScriptUserStateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementScriptUserState.class, cp -> new DeviceManagementScriptUserStateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

}
