package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementReusablePolicySetting;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationPolicyRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementReusablePolicySettingRequest;

public class DeviceManagementReusablePolicySettingCollectionRequest extends CollectionPageEntityRequest<DeviceManagementReusablePolicySetting, DeviceManagementReusablePolicySettingRequest>{

    protected ContextPath contextPath;

    public DeviceManagementReusablePolicySettingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementReusablePolicySetting.class, cp -> new DeviceManagementReusablePolicySettingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementConfigurationPolicyRequest referencingConfigurationPolicies(String id) {
        return new DeviceManagementConfigurationPolicyRequest(contextPath.addSegment("referencingConfigurationPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyCollectionRequest referencingConfigurationPolicies() {
        return new DeviceManagementConfigurationPolicyCollectionRequest(contextPath.addSegment("referencingConfigurationPolicies"), Optional.empty());
    }

}
