package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementResourceAccessProfileBase;
import odata.msgraph.client.beta.entity.request.DeviceManagementResourceAccessProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementResourceAccessProfileBaseRequest;
import odata.msgraph.client.beta.enums.PolicyPlatformType;

public class DeviceManagementResourceAccessProfileBaseCollectionRequest extends CollectionPageEntityRequest<DeviceManagementResourceAccessProfileBase, DeviceManagementResourceAccessProfileBaseRequest>{

    protected ContextPath contextPath;

    public DeviceManagementResourceAccessProfileBaseCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementResourceAccessProfileBase.class, cp -> new DeviceManagementResourceAccessProfileBaseRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementResourceAccessProfileAssignmentRequest assignments(String id) {
        return new DeviceManagementResourceAccessProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementResourceAccessProfileAssignmentCollectionRequest assignments() {
        return new DeviceManagementResourceAccessProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "queryByPlatformType")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementResourceAccessProfileBase> queryByPlatformType(PolicyPlatformType platformType) {
        Preconditions.checkNotNull(platformType, "platformType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("platformType", "microsoft.graph.policyPlatformType", platformType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.queryByPlatformType"), DeviceManagementResourceAccessProfileBase.class, _parameters);
    }

}
