package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementIntentSettingCategory;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentSettingCategoryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;

public class DeviceManagementIntentSettingCategoryCollectionRequest extends CollectionPageEntityRequest<DeviceManagementIntentSettingCategory, DeviceManagementIntentSettingCategoryRequest>{

    protected ContextPath contextPath;

    public DeviceManagementIntentSettingCategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementIntentSettingCategory.class, cp -> new DeviceManagementIntentSettingCategoryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("settings"), Optional.empty());
    }

}
