package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementIntent;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentDeviceSettingStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentSettingCategoryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentUserStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingInstanceRequest;

public class DeviceManagementIntentCollectionRequest extends CollectionPageEntityRequest<DeviceManagementIntent, DeviceManagementIntentRequest>{

    protected ContextPath contextPath;

    public DeviceManagementIntentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementIntent.class, cp -> new DeviceManagementIntentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementIntentAssignmentRequest assignments(String id) {
        return new DeviceManagementIntentAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentAssignmentCollectionRequest assignments() {
        return new DeviceManagementIntentAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceManagementIntentSettingCategoryRequest categories(String id) {
        return new DeviceManagementIntentSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentSettingCategoryCollectionRequest categories() {
        return new DeviceManagementIntentSettingCategoryCollectionRequest(contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceManagementIntentDeviceSettingStateSummaryRequest deviceSettingStateSummaries(String id) {
        return new DeviceManagementIntentDeviceSettingStateSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest deviceSettingStateSummaries() {
        return new DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest(contextPath.addSegment("deviceSettingStateSummaries"), Optional.empty());
    }

    public DeviceManagementIntentDeviceStateRequest deviceStates(String id) {
        return new DeviceManagementIntentDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentDeviceStateCollectionRequest deviceStates() {
        return new DeviceManagementIntentDeviceStateCollectionRequest(contextPath.addSegment("deviceStates"), Optional.empty());
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(contextPath.addSegment("settings"), Optional.empty());
    }

    public DeviceManagementIntentUserStateRequest userStates(String id) {
        return new DeviceManagementIntentUserStateRequest(contextPath.addSegment("userStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentUserStateCollectionRequest userStates() {
        return new DeviceManagementIntentUserStateCollectionRequest(contextPath.addSegment("userStates"), Optional.empty());
    }

}
