package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementConfigurationSettingTemplate;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationSettingDefinitionRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationSettingTemplateRequest;

public class DeviceManagementConfigurationSettingTemplateCollectionRequest extends CollectionPageEntityRequest<DeviceManagementConfigurationSettingTemplate, DeviceManagementConfigurationSettingTemplateRequest>{

    protected ContextPath contextPath;

    public DeviceManagementConfigurationSettingTemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementConfigurationSettingTemplate.class, cp -> new DeviceManagementConfigurationSettingTemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementConfigurationSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementConfigurationSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(contextPath.addSegment("settingDefinitions"), Optional.empty());
    }

}
