package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementConfigurationSetting;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationSettingDefinitionRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationSettingRequest;

public class DeviceManagementConfigurationSettingCollectionRequest extends CollectionPageEntityRequest<DeviceManagementConfigurationSetting, DeviceManagementConfigurationSettingRequest>{

    protected ContextPath contextPath;

    public DeviceManagementConfigurationSettingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementConfigurationSetting.class, cp -> new DeviceManagementConfigurationSettingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementConfigurationSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementConfigurationSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(contextPath.addSegment("settingDefinitions"), Optional.empty());
    }

}
