package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementConfigurationPolicyTemplate;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationPolicyTemplateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationSettingTemplateRequest;

public class DeviceManagementConfigurationPolicyTemplateCollectionRequest extends CollectionPageEntityRequest<DeviceManagementConfigurationPolicyTemplate, DeviceManagementConfigurationPolicyTemplateRequest>{

    protected ContextPath contextPath;

    public DeviceManagementConfigurationPolicyTemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementConfigurationPolicyTemplate.class, cp -> new DeviceManagementConfigurationPolicyTemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementConfigurationSettingTemplateRequest settingTemplates(String id) {
        return new DeviceManagementConfigurationSettingTemplateRequest(contextPath.addSegment("settingTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingTemplateCollectionRequest settingTemplates() {
        return new DeviceManagementConfigurationSettingTemplateCollectionRequest(contextPath.addSegment("settingTemplates"), Optional.empty());
    }

}
