package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.request.DeviceManagementComplianceActionItemRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementComplianceScheduledActionForRuleRequest;

public class DeviceManagementComplianceScheduledActionForRuleCollectionRequest extends CollectionPageEntityRequest<DeviceManagementComplianceScheduledActionForRule, DeviceManagementComplianceScheduledActionForRuleRequest>{

    protected ContextPath contextPath;

    public DeviceManagementComplianceScheduledActionForRuleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementComplianceScheduledActionForRule.class, cp -> new DeviceManagementComplianceScheduledActionForRuleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementComplianceActionItemRequest scheduledActionConfigurations(String id) {
        return new DeviceManagementComplianceActionItemRequest(contextPath.addSegment("scheduledActionConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementComplianceActionItemCollectionRequest scheduledActionConfigurations() {
        return new DeviceManagementComplianceActionItemCollectionRequest(contextPath.addSegment("scheduledActionConfigurations"), Optional.empty());
    }

}
