package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementAutopilotEvent;
import odata.msgraph.client.beta.entity.request.DeviceManagementAutopilotEventRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementAutopilotPolicyStatusDetailRequest;

public class DeviceManagementAutopilotEventCollectionRequest extends CollectionPageEntityRequest<DeviceManagementAutopilotEvent, DeviceManagementAutopilotEventRequest>{

    protected ContextPath contextPath;

    public DeviceManagementAutopilotEventCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementAutopilotEvent.class, cp -> new DeviceManagementAutopilotEventRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementAutopilotPolicyStatusDetailRequest policyStatusDetails(String id) {
        return new DeviceManagementAutopilotPolicyStatusDetailRequest(contextPath.addSegment("policyStatusDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementAutopilotPolicyStatusDetailCollectionRequest policyStatusDetails() {
        return new DeviceManagementAutopilotPolicyStatusDetailCollectionRequest(contextPath.addSegment("policyStatusDetails"), Optional.empty());
    }

}
