package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceHealthScriptRemediationSummary;
import odata.msgraph.client.beta.entity.DeviceHealthScript;
import odata.msgraph.client.beta.entity.request.DeviceHealthScriptAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceHealthScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceHealthScriptRequest;
import odata.msgraph.client.beta.enums.GlobalDeviceHealthScriptState;

public class DeviceHealthScriptCollectionRequest extends CollectionPageEntityRequest<DeviceHealthScript, DeviceHealthScriptRequest>{

    protected ContextPath contextPath;

    public DeviceHealthScriptCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceHealthScript.class, cp -> new DeviceHealthScriptRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceHealthScriptAssignmentRequest assignments(String id) {
        return new DeviceHealthScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceHealthScriptAssignmentCollectionRequest assignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceHealthScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceHealthScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceHealthScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceHealthScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

    @Action(name = "enableGlobalScripts")
    @JsonIgnore
    public ActionRequestNoReturn enableGlobalScripts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableGlobalScripts"), _parameters);
    }

    @Function(name = "areGlobalScriptsAvailable")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GlobalDeviceHealthScriptState> areGlobalScriptsAvailable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<GlobalDeviceHealthScriptState>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.areGlobalScriptsAvailable"), GlobalDeviceHealthScriptState.class, _parameters);
    }

    @Function(name = "getRemediationSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceHealthScriptRemediationSummary> getRemediationSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceHealthScriptRemediationSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRemediationSummary"), DeviceHealthScriptRemediationSummary.class, _parameters);
    }

}
