package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.request.DeviceComplianceActionItemRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScheduledActionForRuleRequest;

public class DeviceComplianceScheduledActionForRuleCollectionRequest extends CollectionPageEntityRequest<DeviceComplianceScheduledActionForRule, DeviceComplianceScheduledActionForRuleRequest>{

    protected ContextPath contextPath;

    public DeviceComplianceScheduledActionForRuleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceComplianceScheduledActionForRule.class, cp -> new DeviceComplianceScheduledActionForRuleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceComplianceActionItemRequest scheduledActionConfigurations(String id) {
        return new DeviceComplianceActionItemRequest(contextPath.addSegment("scheduledActionConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceActionItemCollectionRequest scheduledActionConfigurations() {
        return new DeviceComplianceActionItemCollectionRequest(contextPath.addSegment("scheduledActionConfigurations"), Optional.empty());
    }

}
