package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceAndAppManagementRoleAssignment;
import odata.msgraph.client.beta.entity.request.DeviceAndAppManagementRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.RoleScopeTagRequest;

public class DeviceAndAppManagementRoleAssignmentCollectionRequest extends CollectionPageEntityRequest<DeviceAndAppManagementRoleAssignment, DeviceAndAppManagementRoleAssignmentRequest>{

    protected ContextPath contextPath;

    public DeviceAndAppManagementRoleAssignmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceAndAppManagementRoleAssignment.class, cp -> new DeviceAndAppManagementRoleAssignmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RoleScopeTagRequest roleScopeTags(String id) {
        return new RoleScopeTagRequest(contextPath.addSegment("roleScopeTags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleScopeTagCollectionRequest roleScopeTags() {
        return new RoleScopeTagCollectionRequest(contextPath.addSegment("roleScopeTags"), Optional.empty());
    }

}
