package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DetectedApp;
import odata.msgraph.client.beta.entity.request.DetectedAppRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;

public class DetectedAppCollectionRequest extends CollectionPageEntityRequest<DetectedApp, DetectedAppRequest>{

    protected ContextPath contextPath;

    public DetectedAppCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DetectedApp.class, cp -> new DetectedAppRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(contextPath.addSegment("managedDevices"), Optional.empty());
    }

}
